/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.perks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.resource.SingleJsonFileReloadListener;
import dev.toma.gunsrpg.resource.adapter.BreakChanceReductionAdapter;
import dev.toma.gunsrpg.resource.adapter.BreakChanceReductionsAdapter;
import dev.toma.gunsrpg.resource.adapter.CountFunctionAdapter;
import dev.toma.gunsrpg.resource.adapter.CrystalConfigurationAdapter;
import dev.toma.gunsrpg.resource.adapter.CrystalSpawnAdapter;
import dev.toma.gunsrpg.resource.adapter.CrystalSpawnsAdapter;
import dev.toma.gunsrpg.resource.adapter.CrystalStorageAdapter;
import dev.toma.gunsrpg.resource.adapter.CrystalTypesAdapter;
import dev.toma.gunsrpg.resource.adapter.FusionConfigurationAdapter;
import dev.toma.gunsrpg.resource.adapter.FusionSwapAdapter;
import dev.toma.gunsrpg.resource.adapter.FusionSwapsAdapter;
import dev.toma.gunsrpg.resource.adapter.FusionUpgradeAdapter;
import dev.toma.gunsrpg.resource.adapter.FusionUpgradesAdapter;
import dev.toma.gunsrpg.resource.adapter.PerkConfigurationAdapter;
import dev.toma.gunsrpg.resource.adapter.PurificationConfigurationAdapter;
import dev.toma.gunsrpg.resource.adapter.PurificationEntryAdapter;
import dev.toma.gunsrpg.resource.crate.ICountFunction;
import dev.toma.gunsrpg.resource.perks.CrystalConfiguration;
import dev.toma.gunsrpg.resource.perks.FusionConfiguration;
import dev.toma.gunsrpg.resource.perks.PerkConfiguration;
import dev.toma.gunsrpg.resource.perks.PurificationConfiguration;
import dev.toma.gunsrpg.resource.util.functions.ComparatorFunction;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class PerkConfigurationLoader
extends SingleJsonFileReloadListener {
    private static final Marker MARKER = MarkerManager.getMarker((String)"Perks");
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(PerkConfiguration.class, (Object)new PerkConfigurationAdapter()).registerTypeHierarchyAdapter(ICountFunction.class, (Object)new CountFunctionAdapter(new ComparatorFunction(ComparatorFunction.BIGGER_EQUAL, -1))).registerTypeAdapter(CrystalConfiguration.class, (Object)new CrystalConfigurationAdapter()).registerTypeAdapter(CrystalConfiguration.Spawns.class, (Object)new CrystalSpawnsAdapter()).registerTypeAdapter(CrystalConfiguration.Spawn.class, (Object)new CrystalSpawnAdapter()).registerTypeAdapter(CrystalConfiguration.Types.class, (Object)new CrystalTypesAdapter()).registerTypeAdapter(CrystalConfiguration.Storage.class, (Object)new CrystalStorageAdapter()).registerTypeAdapter(FusionConfiguration.class, (Object)new FusionConfigurationAdapter()).registerTypeAdapter(FusionConfiguration.Upgrades.class, (Object)new FusionUpgradesAdapter()).registerTypeAdapter(FusionConfiguration.Upgrade.class, (Object)new FusionUpgradeAdapter()).registerTypeAdapter(FusionConfiguration.Swaps.class, (Object)new FusionSwapsAdapter()).registerTypeAdapter(FusionConfiguration.Swap.class, (Object)new FusionSwapAdapter()).registerTypeAdapter(PurificationConfiguration.class, (Object)new PurificationConfigurationAdapter()).registerTypeAdapter(PurificationConfiguration.Entry.class, (Object)new PurificationEntryAdapter()).registerTypeAdapter(FusionConfiguration.BreakChanceReduction.class, (Object)new BreakChanceReductionAdapter()).registerTypeAdapter(FusionConfiguration.BreakChanceReductions.class, (Object)new BreakChanceReductionsAdapter()).create();
    private PerkConfiguration configuration;

    public PerkConfigurationLoader() {
        super(GunsRPG.makeResource("perk_configuration.json"), GSON);
    }

    public PerkConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(PerkConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void apply(JsonElement element, IResourceManager manager, IProfiler profiler) {
        GunsRPG.log.info(MARKER, "Loading perk configuration");
        try {
            this.configuration = (PerkConfiguration)GSON.fromJson(element, PerkConfiguration.class);
            GunsRPG.log.info(MARKER, "Perk configuration has been loaded");
        }
        catch (JsonParseException e) {
            GunsRPG.log.error(MARKER, "Error loading perk configuration: {}", (Object)e.toString());
        }
    }
}

